require( "HiddenObject/script/style.lua" )

HeaderFont = {
  standardFont,
  35,
  WhiteColor
};

TableInfoFont = {
  standardFont,
  30,
 WhiteColor
};

ErrorFont = {
  standardFont,
  24,
 WhiteColor
};

AccountFont = {
  standardFont,
  24,
  WhiteColor
};

AccountFont2 = {
  standardFont,
  24,
  BlackColor
};

ScoreFont = {
  standardFont,
  14,
  WhiteColor
};

HiscoreSubmitLegal = {
  standardFont,
  14,
  WhiteColor
};

kPlayerNameY = 150;
kScoreY = 200;
kYourPFAccountY = 235;
kAccountNameY = 275;
kPasswordY = 310;
kRememberY = 350;

kPrivacyLabel = 'privacy';
if (IsEnabled(kHiscoreAnonymous)) then
	kPrivacyLabel = 'privacy_info';
end


function SwitchModes( submit )
	
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	if submit then
		DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
	else
		DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
	end

	EnableWindow("header",not submit);
	EnableWindow("headershadow",not submit);
	EnableWindow("playertext", not submit);
	EnableWindow("yourscore", not submit);
	EnableWindow("eligiblescore", not submit);

	EnableWindow("nameeditbox", not submit );

	EnableWindow("submittoserver", not submit);
	EnableWindow("submitcancel", not submit);
	EnableWindow("submitconnect", submit);

end

MakeDialog
{
	name="hiscoresubmitscreen",
	Bitmap
	{ 
		image="HiddenObject/UI/background/largedialog",	
		x=kCenter,
		y=kCenter,

		SetStyle(DefaultStyle);
		Text
		{
			font = HeaderFont,
			name = "header",
			x=0,y=40,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=0,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=0,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=0,y=0,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=0,y=0,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};
		
		Text
		{
			x = 20, w = kMax-20,
			y = 400, h = kMax,
			font = HiscoreSubmitLegal;
			flags = kHAlignLeft + kVAlignTop,
			label = kPrivacyLabel
		};

		Bitmap
		{
			name="nameeditbox",
			image="HiddenObject/UI/background/textfield.png",
			x=155,
			y=kPlayerNameY,
			
			TextEdit
			{
				font = AccountFont,
				name = "nameedit",
				label = gNameEdit,
				x=0,y=3,w=kMax,h=kMax,
				length=12,
				ignore = kIllegalNameChars
				
			};
		};
		
		
		SetStyle( ButtonStyle ),
		Button
		{
			x=80, y=450,

			name="submittoserver",
			label="submit",
			type = kPush,
			default= true, -- this should be the default button (on enter)

			command = 
				function()
					name = GetLabel("playerlabel");
					SubmitToServer(name);
				end
		},
		
		Button
		{
			x=275, y=450,

			name="submitcancel",
			label="cancel",
			type = kPush,
			command = 
				function()
					PopModal("hiscoresubmitscreen"); -- take off high score menu, restart game loop
				end
		};
		
		Button
		{
			x=150, y=kMax-50,

			name="submiterrorok",
			label="ok",
			type = kPush,
			command=
				function()
					EnableWindow("submiterrorok",false);
					EnableWindow("submiterror",false);
					SwitchModes(false);
				end
		};
		
		Button
		{
			x=0,
			y=0,
			w=0,
			h=0,
			graphics={},
			name="privacybutton",
			command = 
				function()
					if (IsEnabled(kHiscoreAnonymous)) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="privacy_anon",
							title = ""
						};
					else
						LaunchPrivacyPolicy();
					end
				end
		};
	}
}

EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);
SetButtonToggleState('remember',gRemember);
SetFocus("nameedit");